<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>¡Gracias por tu interés!</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gradient-to-br from-green-50 to-blue-50 min-h-screen">
    <div class="container mx-auto px-4 py-8">
        <div class="max-w-2xl mx-auto text-center">
            <!-- Success Animation -->
            <div class="mb-8">
                <div class="w-24 h-24 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <svg class="w-12 h-12 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>

                <h1 class="text-4xl font-bold text-gray-900 mb-4">
                    🎉 ¡Información Recibida!
                </h1>

                <p class="text-lg text-gray-600 mb-8">
                    Gracias por tu interés. Hemos recibido tu información y nuestro equipo te contactará muy pronto.
                </p>
            </div>

            <!-- Qué sigue -->
            <div class="bg-white rounded-2xl shadow-xl p-8 mb-8">
                <h2 class="text-2xl font-semibold text-gray-900 mb-6">¿Qué sigue ahora?</h2>

                <div class="space-y-6">
                    <div class="flex items-start space-x-4">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                            <span class="text-blue-600 font-semibold">1</span>
                        </div>
                        <div class="text-left">
                            <h3 class="font-semibold text-gray-900">Revisión de tu solicitud</h3>
                            <p class="text-gray-600">Nuestro equipo revisará tu información en las próximas horas.</p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-4">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                            <span class="text-blue-600 font-semibold">2</span>
                        </div>
                        <div class="text-left">
                            <h3 class="font-semibold text-gray-900">Contacto personalizado</h3>
                            <p class="text-gray-600">Te contactaremos por email o teléfono en menos de 24 horas.</p>
                        </div>
                    </div>

                    <div class="flex items-start space-x-4">
                        <div class="flex-shrink-0 w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                            <span class="text-blue-600 font-semibold">3</span>
                        </div>
                        <div class="text-left">
                            <h3 class="font-semibold text-gray-900">Propuesta personalizada</h3>
                            <p class="text-gray-600">Te enviaremos información específica para tus necesidades.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Información adicional -->
            <div class="bg-blue-50 rounded-xl p-6 mb-8">
                <h3 class="text-lg font-semibold text-blue-900 mb-2">📧 Revisa tu email</h3>
                <p class="text-blue-700">
                    Te hemos enviado un email de confirmación. Si no lo ves, revisa tu carpeta de spam.
                </p>
            </div>

            <!-- Call to action adicional -->
            <div class="space-y-4">
                <p class="text-gray-600">¿Tienes prisa? Contáctanos directamente:</p>

                <div class="flex justify-center space-x-4">
                    <a href="mailto:info@tuempresa.com"
                        class="bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition-colors">
                        📧 Email directo
                    </a>
                    <a href="tel:+5299999999"
                        class="bg-green-600 text-white px-6 py-3 rounded-lg hover:bg-green-700 transition-colors">
                        📞 Llamar ahora
                    </a>
                </div>

                <div class="mt-8">
                    <a href="/" class="text-blue-600 hover:text-blue-800 underline">
                        ← Volver al sitio principal
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts de conversión -->
    <script>
        // Google Analytics conversion
        // gtag('event', 'conversion', {'send_to': 'AW-CONVERSION_ID/CONVERSION_LABEL'});

        // Facebook Pixel conversion
        // fbq('track', 'Lead');

        console.log('Lead conversion completed');

        // Auto-redirect después de 10 segundos (opcional)
        // setTimeout(() => {
        //     window.location.href = '/';
        // }, 10000);
    </script>
</body>

</html>