<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $title ?? 'Contáctanos' }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <meta name="description" content="Contáctanos para más información sobre nuestros servicios">

    <!-- Facebook Pixel (opcional) -->
    <meta property="og:title" content="{{ $title ?? 'Contáctanos' }}">
    <meta property="og:description" content="Obtén información gratuita sobre nuestros servicios">
    <meta property="og:type" content="website">
</head>

<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen">
    <div class="container mx-auto px-4 py-8">
        <div class="max-w-2xl mx-auto">
            <!-- Header -->
            <div class="text-center mb-8">
                <h1 class="text-4xl font-bold text-gray-900 mb-4">
                    🎯 ¡Obtén Información Gratuita!
                </h1>
                <p class="text-lg text-gray-600">
                    Completa el formulario y te contactaremos con información personalizada
                </p>
            </div>

            <!-- Formulario -->
            <div class="bg-white rounded-2xl shadow-xl p-8">
                @if(session('error'))
                <div class="mb-6 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded">
                    {{ session('error') }}
                </div>
                @endif

                <form action="{{ route('public.lead.submit') }}" method="POST" class="space-y-6">
                    @csrf
                    <input type="hidden" name="account_id" value="{{ $account_id }}">
                    <input type="hidden" name="source" value="{{ $source }}">

                    <!-- Nombre -->
                    <div>
                        <label for="full_name" class="block text-sm font-medium text-gray-700 mb-2">
                            Nombre Completo *
                        </label>
                        <input
                            type="text"
                            id="full_name"
                            name="full_name"
                            value="{{ old('full_name') }}"
                            required
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                            placeholder="Tu nombre completo">
                        @error('full_name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Email -->
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                            Email *
                        </label>
                        <input
                            type="email"
                            id="email"
                            name="email"
                            value="{{ old('email') }}"
                            required
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                            placeholder="tu@email.com">
                        @error('email')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Teléfono -->
                    <div>
                        <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">
                            Teléfono
                        </label>
                        <input
                            type="tel"
                            id="phone"
                            name="phone"
                            value="{{ old('phone') }}"
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                            placeholder="+52 999 999 9999">
                        @error('phone')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Empresa -->
                    <div>
                        <label for="company" class="block text-sm font-medium text-gray-700 mb-2">
                            Empresa
                        </label>
                        <input
                            type="text"
                            id="company"
                            name="company"
                            value="{{ old('company') }}"
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                            placeholder="Nombre de tu empresa">
                        @error('company')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Interés -->
                    <div>
                        <label for="interest" class="block text-sm font-medium text-gray-700 mb-2">
                            ¿Qué te interesa?
                        </label>
                        <select
                            id="interest"
                            name="interest"
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                            <option value="">Selecciona una opción</option>
                            <option value="servicios_generales" {{ old('interest') == 'servicios_generales' ? 'selected' : '' }}>
                                Servicios Generales
                            </option>
                            <option value="consultoria" {{ old('interest') == 'consultoria' ? 'selected' : '' }}>
                                Consultoría
                            </option>
                            <option value="desarrollo_software" {{ old('interest') == 'desarrollo_software' ? 'selected' : '' }}>
                                Desarrollo de Software
                            </option>
                            <option value="marketing_digital" {{ old('interest') == 'marketing_digital' ? 'selected' : '' }}>
                                Marketing Digital
                            </option>
                            <option value="otros" {{ old('interest') == 'otros' ? 'selected' : '' }}>
                                Otros
                            </option>
                        </select>
                        @error('interest')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Mensaje -->
                    <div>
                        <label for="message" class="block text-sm font-medium text-gray-700 mb-2">
                            Mensaje
                        </label>
                        <textarea
                            id="message"
                            name="message"
                            rows="4"
                            class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors"
                            placeholder="Cuéntanos más sobre lo que necesitas...">{{ old('message') }}</textarea>
                        @error('message')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Botón submit -->
                    <div class="pt-4">
                        <button
                            type="submit"
                            class="w-full bg-gradient-to-r from-blue-600 to-indigo-600 text-white font-semibold py-4 px-6 rounded-lg hover:from-blue-700 hover:to-indigo-700 transform hover:scale-105 transition-all duration-200 shadow-lg">
                            🚀 Enviar Información
                        </button>
                    </div>

                    <!-- Disclaimer -->
                    <div class="text-center text-sm text-gray-500">
                        <p>Al enviar este formulario, aceptas que te contactemos con información relevante.</p>
                        <p class="mt-1">No compartimos tu información con terceros.</p>
                    </div>
                </form>
            </div>

            <!-- Beneficios -->
            <div class="mt-8 grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="bg-white p-4 rounded-lg shadow text-center">
                    <div class="text-2xl mb-2">⚡</div>
                    <h3 class="font-semibold text-gray-900">Respuesta Rápida</h3>
                    <p class="text-sm text-gray-600">Te contactamos en menos de 24 horas</p>
                </div>
                <div class="bg-white p-4 rounded-lg shadow text-center">
                    <div class="text-2xl mb-2">🎯</div>
                    <h3 class="font-semibold text-gray-900">Información Personalizada</h3>
                    <p class="text-sm text-gray-600">Soluciones adaptadas a tus necesidades</p>
                </div>
                <div class="bg-white p-4 rounded-lg shadow text-center">
                    <div class="text-2xl mb-2">🔒</div>
                    <h3 class="font-semibold text-gray-900">Datos Seguros</h3>
                    <p class="text-sm text-gray-600">Tu información está completamente protegida</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Script para tracking (opcional) -->
    <script>
        // Google Analytics, Facebook Pixel, etc.
        console.log('Formulario de lead cargado desde: {{ $source }}');

        // Track form submission
        document.querySelector('form').addEventListener('submit', function() {
            console.log('Lead form submitted');
            // Aquí puedes agregar tracking de conversiones
        });
    </script>
</body>

</html>