<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;
use App\Models\User;

class PlanesPermissionsSeeder extends Seeder
{
    public function run()
    {
        // Crear permisos para planes
        $permisos = [
            'planes.ver',
            'planes.crear',
            'planes.editar',
            'planes.eliminar',
        ];

        foreach ($permisos as $nombre) {
            Permission::firstOrCreate(['name' => $nombre]);
        }

        // Asignar todos los permisos de planes al rol Super Admin
        $superAdminRole = Role::where('name', 'Super Admin')->first();
        if ($superAdminRole) {
            $superAdminRole->givePermissionTo($permisos);
        }

        // Asignar permisos básicos al rol Admin
        $adminRole = Role::where('name', 'Admin')->first();
        if ($adminRole) {
            $adminRole->givePermissionTo(['planes.ver', 'planes.crear', 'planes.editar']);
        }

        $this->command->info('Permisos de planes creados y asignados correctamente.');
    }
}
