<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('usuario_creditos', function (Blueprint $table) {
            $table->id();
            
            // Usuario al que pertenecen los créditos
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            
            // Período de control (para resetear créditos)
            $table->date('fecha_periodo'); // Fecha del día o mes que se está controlando
            $table->enum('tipo_periodo', ['diario', 'mensual']);
            
            // Créditos utilizados en este período
            $table->integer('creditos_utilizados')->default(0);
            $table->integer('limite_creditos'); // Límite según su plan
            
            // Metadatos
            $table->timestamp('ultimo_uso')->nullable(); // Última vez que usó créditos
            $table->json('detalle_uso')->nullable(); // Detalle de cómo se usaron los créditos
            
            $table->timestamps();
            
            // Índice único para evitar duplicados por usuario/período
            $table->unique(['user_id', 'fecha_periodo', 'tipo_periodo']);
            
            // Índices para optimizar consultas
            $table->index(['user_id', 'tipo_periodo']);
            $table->index('fecha_periodo');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('usuario_creditos');
    }
};
