<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('enriquecimiento_importaciones', function (Blueprint $table) {
            $table->id();

            // Usuario que realizó la importación
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // Información de la importación
            $table->string('nombre_archivo')->nullable(); // Si es archivo Excel
            $table->enum('tipo_importacion', ['excel', 'manual']);
            $table->integer('total_numeros')->default(0); // Total de números en la importación
            $table->integer('numeros_procesados')->default(0); // Números ya procesados por el bot
            $table->integer('numeros_pendientes')->default(0); // Números pendientes de procesar
            $table->integer('creditos_consumidos')->default(0); // Créditos consumidos en esta importación

            // Estado de la importación
            $table->enum('estado', [
                'pendiente',      // Recién subida, sin procesar
                'procesando',     // Bot está procesando
                'procesado',      // Todos los números procesados
                'rechazado',      // Rechazado o con error
                'cancelado'       // Cancelado por el usuario (no se puede reanudar)
            ])->default('pendiente');

            // Metadatos adicionales
            $table->json('metadatos')->nullable(); // Información adicional del proceso
            $table->text('observaciones')->nullable(); // Observaciones del usuario o sistema

            // Campos de fechas y control de procesamiento
            $table->timestamp('fecha_importacion')->nullable(); // Fecha cuando se realizó la importación
            $table->timestamp('ultima_ejecucion')->nullable(); // Última vez que se ejecutó el procesamiento
            $table->timestamp('fecha_completado')->nullable(); // Fecha cuando se completó el procesamiento
            $table->text('mensaje_error')->nullable(); // Mensaje de error si algo falló

            $table->timestamps();

            // Índices para optimizar consultas
            $table->index(['user_id', 'created_at']);
            $table->index('estado');
            $table->index('tipo_importacion');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('enriquecimiento_importaciones');
    }
};
