<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('reportes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('cartera_id')
                ->nullable()
                ->constrained('carteras')
                ->nullOnDelete();
            $table->string('nombre');
            $table->string('link_desktop')->nullable();
            $table->string('link_mobile')->nullable();
            $table->text('icon')->nullable();
            $table->integer('orden')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reportes');
    }
};
