<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tipos_documento', function (Blueprint $table) {
            $table->id();
            $table->string('codigo', 10)->unique(); // DNI, NIE, RUC, etc.
            $table->string('nombre', 100); // Nombre completo del documento
            $table->string('pais', 50); // País de origen
            $table->text('descripcion')->nullable(); // Descripción adicional
            $table->boolean('activo')->default(true); // Si está activo o no
            $table->integer('orden')->default(0); // Para ordenar la lista
            $table->timestamps();
        });

        // Insertar los tipos de documento
        DB::table('tipos_documento')->insert([
            // Documentos de Perú
            ['codigo' => 'DNI', 'nombre' => 'Documento Nacional de Identidad', 'pais' => 'Perú', 'descripcion' => 'Documento de identidad para ciudadanos peruanos', 'orden' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['codigo' => 'CE', 'nombre' => 'Carné de Extranjería', 'pais' => 'Perú', 'descripcion' => 'Documento para extranjeros residentes en Perú', 'orden' => 2, 'created_at' => now(), 'updated_at' => now()],
            ['codigo' => 'PTP', 'nombre' => 'Permiso Temporal de Permanencia', 'pais' => 'Perú', 'descripcion' => 'Permiso temporal para extranjeros en Perú', 'orden' => 3, 'created_at' => now(), 'updated_at' => now()],
            ['codigo' => 'CPP', 'nombre' => 'Carné de Permiso de Permanencia', 'pais' => 'Perú', 'descripcion' => 'Carné de permanencia para extranjeros en Perú', 'orden' => 4, 'created_at' => now(), 'updated_at' => now()],
            ['codigo' => 'RUC', 'nombre' => 'Registro Único del Contribuyente', 'pais' => 'Perú', 'descripcion' => 'Documento tributario para personas jurídicas y naturales', 'orden' => 5, 'created_at' => now(), 'updated_at' => now()],
            
            // Documentos de España
            ['codigo' => 'NIF', 'nombre' => 'Número de Identificación Fiscal', 'pais' => 'España', 'descripcion' => 'Documento de identidad fiscal para ciudadanos españoles', 'orden' => 6, 'created_at' => now(), 'updated_at' => now()],
            ['codigo' => 'NIE', 'nombre' => 'Número de Identidad de Extranjero', 'pais' => 'España', 'descripcion' => 'Documento para extranjeros en España', 'orden' => 7, 'created_at' => now(), 'updated_at' => now()],
            ['codigo' => 'CIF', 'nombre' => 'Código de Identificación Fiscal', 'pais' => 'España', 'descripcion' => 'Documento fiscal para personas jurídicas en España', 'orden' => 8, 'created_at' => now(), 'updated_at' => now()],
            ['codigo' => 'TIE', 'nombre' => 'Tarjeta de Identidad de Extranjero', 'pais' => 'España', 'descripcion' => 'Tarjeta de identidad para extranjeros residentes en España', 'orden' => 9, 'created_at' => now(), 'updated_at' => now()],
            
            // Documentos internacionales
            ['codigo' => 'PASAPORTE', 'nombre' => 'Pasaporte', 'pais' => 'Internacional', 'descripcion' => 'Documento de viaje internacional', 'orden' => 10, 'created_at' => now(), 'updated_at' => now()],
            ['codigo' => 'OTROS', 'nombre' => 'Otros documentos', 'pais' => 'Internacional', 'descripcion' => 'Otros tipos de documentos de identidad', 'orden' => 99, 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tipos_documento');
    }
};
