<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TipoDocumento extends Model
{
    use HasFactory;

    protected $table = 'tipos_documento';

    protected $fillable = [
        'codigo',
        'nombre',
        'pais',
        'descripcion',
        'activo',
        'orden'
    ];

    protected $casts = [
        'activo' => 'boolean',
        'orden' => 'integer'
    ];

    // Scope para obtener solo los tipos activos
    public function scopeActivos($query)
    {
        return $query->where('activo', true);
    }

    // Scope para ordenar por orden
    public function scopeOrdenado($query)
    {
        return $query->orderBy('orden');
    }

    // Scope para filtrar por país
    public function scopePorPais($query, $pais)
    {
        return $query->where('pais', $pais);
    }

    // Relación con usuarios
    public function usuarios()
    {
        return $this->hasMany(User::class, 'tipo_documento_id');
    }

    // Relación con historial registros vodafone
    public function historialRegistrosVodafone()
    {
        return $this->hasMany(Vodafone::class, 'tipo_documento_id');
    }

    // Método para obtener el código y nombre juntos
    public function getCodigoNombreAttribute()
    {
        return $this->codigo . ' - ' . $this->nombre;
    }

    // Método para obtener descripción con país
    public function getDescripcionCompletaAttribute()
    {
        return $this->nombre . ' (' . $this->pais . ')';
    }
}
