<?php

namespace App\Http\Traits;

trait AlertResponseTrait
{
    /**
     * Redirect with success alert
     */
    protected function redirectWithSuccess(string $message, string $route = null, array $routeParams = []): \Illuminate\Http\RedirectResponse
    {
        $redirect = $route ? redirect()->route($route, $routeParams) : redirect()->back();

        return $redirect->with('alert', [
            'type' => 'success',
            'message' => $message,
            'mode' => 'toast',
            'timer' => 3000
        ]);
    }

    /**
     * Redirect with validation error alert
     */
    protected function redirectWithValidationError(\Illuminate\Validation\ValidationException $exception, string $message = 'Verifica los datos ingresados'): \Illuminate\Http\RedirectResponse
    {
        return redirect()->back()
            ->withErrors($exception->validator)
            ->withInput()
            ->with('alert', [
                'type' => 'error',
                'message' => $message,
                'timer' => 4000
            ]);
    }

    /**
     * Redirect with error alert
     */
    protected function redirectWithError(string $message, \Exception $exception = null): \Illuminate\Http\RedirectResponse
    {
        // Si es un error de validación de negocio, mostrar como warning
        if ($exception instanceof \InvalidArgumentException) {
            return redirect()->back()->with('alert', [
                'type' => 'warning',
                'message' => $exception->getMessage(),
                'timer' => 5000
            ]);
        }

        $errorMessage = $exception ? $exception->getMessage() : $message;

        return redirect()->back()
            ->withInput()
            ->with('alert', [
                'type' => 'error',
                'message' => $errorMessage,
                'timer' => 4000
            ]);
    }

    /**
     * Redirect with warning alert
     */
    protected function redirectWithWarning(string $message, string $route = null, array $routeParams = []): \Illuminate\Http\RedirectResponse
    {
        $redirect = $route ? redirect()->route($route, $routeParams) : redirect()->back();

        return $redirect->with('alert', [
            'type' => 'warning',
            'message' => $message,
            'timer' => 5000
        ]);
    }

    /**
     * Redirect with info alert
     */
    protected function redirectWithInfo(string $message, string $route = null, array $routeParams = []): \Illuminate\Http\RedirectResponse
    {
        $redirect = $route ? redirect()->route($route, $routeParams) : redirect()->back();

        return $redirect->with('alert', [
            'type' => 'info',
            'message' => $message,
            'timer' => 4000
        ]);
    }

    /**
     * Get the index route name for the current controller
     * Override this method in controllers if needed
     */
    protected function getIndexRoute(): string
    {
        $controllerName = class_basename(static::class);
        $resourceName = strtolower(str_replace('Controller', '', $controllerName));
        return $resourceName . '.index';
    }
}
