<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateVodafoneRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $vodafone = $this->route('vodafone');

        return [
            // Campos principales requeridos
            'user_id' => 'required|exists:users,id',
            'nombre_cliente' => 'required|string|max:255',
            'numero_documento' => [
                'required',
                'string',
                'max:255',
                Rule::unique('historial_registros_vodafone', 'numero_documento')->ignore($vodafone->id)
            ],
            'telefono_principal' => 'required|string|max:20',

            // Campos opcionales de relación
            'asignado_a_id' => 'nullable|exists:users,id',
            'tipo_documento_id' => 'nullable|exists:tipos_documento,id',

            // Campos opcionales de información
            'orden_trabajo_anterior' => 'nullable|string|max:255',
            'origen_base' => 'nullable|string|max:255',
            'telefono_adicional' => 'nullable|string|max:20',
            'correo_referencia' => 'nullable|email|max:255',
            'direccion_historico' => 'nullable|string|max:255',
            'marca_base' => 'nullable|string|max:255',
            'origen_motivo_cancelacion' => 'nullable|string|max:255',
            'observaciones' => 'nullable|string',

            // Campos de operador y whatsapp
            'operador_telefono_principal' => 'nullable|string|max:255',
            'ultact_operador_tel_prin' => 'nullable|date',
            'operador_telefono_adicional' => 'nullable|string|max:255',
            'ultact_operador_tel_adic' => 'nullable|date',
            'operador_telefono_prin_whatsapp' => 'nullable|boolean',
            'operador_telefono_adic_whatsapp' => 'nullable|boolean',

            // Campos de tipo de teléfono
            'tipo_telefono_principal' => 'nullable|string|max:50',
            'tipo_telefono_adicional' => 'nullable|string|max:50',

            // Campos de tipo de WhatsApp
            'tipo_whatsapp_principal' => 'nullable|string|in:business,normal',
            'tipo_whatsapp_adicional' => 'nullable|string|in:business,normal',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'user_id.required' => 'El usuario es obligatorio.',
            'user_id.exists' => 'El usuario seleccionado no existe.',
            'nombre_cliente.required' => 'El nombre del cliente es obligatorio.',
            'numero_documento.required' => 'El número de documento es obligatorio.',
            'numero_documento.unique' => 'Ya existe un registro con este número de documento.',
            'telefono_principal.required' => 'El teléfono principal es obligatorio.',
            'correo_referencia.email' => 'El correo debe tener un formato válido.',
            'tipo_whatsapp_principal.in' => 'El tipo de WhatsApp principal debe ser business o normal.',
            'tipo_whatsapp_adicional.in' => 'El tipo de WhatsApp adicional debe ser business o normal.',
        ];
    }
}
