<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateReporteRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nombre' => 'required|string|max:255',
            'link_desktop' => 'required|string|max:255',
            'link_mobile' => 'nullable|string|max:255',
            'icon' => 'nullable|string',
            'orden' => 'nullable|integer',
            'cartera_id' => 'required|exists:carteras,id',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'nombre.required' => 'El nombre del reporte es obligatorio.',
            'nombre.max' => 'El nombre del reporte no debe exceder 255 caracteres.',
            'link_desktop.required' => 'El enlace de escritorio es obligatorio.',
            'link_desktop.max' => 'El enlace de escritorio no debe exceder 255 caracteres.',
            'cartera_id.required' => 'La cartera es obligatoria.',
            'cartera_id.exists' => 'La cartera seleccionada no existe.',
        ];
    }
}
