<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|string|min:6',
            'active' => 'boolean',
            'plan_id' => 'nullable|exists:planes,id',
            'tipo_documento_id' => 'nullable|exists:tipos_documento,id',
            'numero_documento' => 'nullable|string|max:255|unique:users,numero_documento',
            'department' => 'nullable|string|max:255',
            'position' => 'nullable|string|max:255',
            'phone' => 'nullable|string|max:20',
            'bio' => 'nullable|string|max:500',
            'carteras' => 'nullable|array',
            'carteras.*' => 'exists:carteras,id',
            'reportes' => 'nullable|array',
            'reportes.*' => 'exists:reportes,id',
            'roles' => 'nullable|array',
            'roles.*' => 'exists:roles,id',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'name.required' => 'El nombre es obligatorio.',
            'name.max' => 'El nombre no debe exceder 255 caracteres.',
            'email.required' => 'El email es obligatorio.',
            'email.email' => 'El email debe tener un formato válido.',
            'email.unique' => 'Ya existe un usuario con este email.',
            'password.required' => 'La contraseña es obligatoria.',
            'password.min' => 'La contraseña debe tener al menos 6 caracteres.',
            'numero_documento.unique' => 'Ya existe un usuario con este número de documento.',
            'plan_id.exists' => 'El plan seleccionado no existe.',
            'tipo_documento_id.exists' => 'El tipo de documento seleccionado no existe.',
        ];
    }
}
