<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ImportarManualEnriquecimientoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'numeros' => 'required|string|min:9',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'numeros.required' => 'Los números son obligatorios.',
            'numeros.string' => 'Los números deben ser texto.',
            'numeros.min' => 'Debe ingresar al menos un número válido (mínimo 9 caracteres).',
        ];
    }
}
