<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Models\Reporte;

class CheckReporteAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();
        $reporteId = $request->route('id');

        if (!$user) {
            return redirect()->route('login');
        }

        // Verificar si el reporte existe
        $reporte = Reporte::find($reporteId);
        if (!$reporte) {
            return redirect()->route('dashboard')
                ->with('alert', [
                    'type' => 'error',
                    'title' => 'Reporte no encontrado',
                    'message' => 'El reporte solicitado no existe o ha sido eliminado.',
                    'timer' => 5000
                ]);
        }

        // Verificar si el usuario tiene acceso al reporte
        $userReportes = $user->getEffectiveReportes();
        if (!$userReportes->contains('id', $reporte->id)) {
            return redirect()->route('dashboard')
                ->with('alert', [
                    'type' => 'error',
                    'title' => 'Acceso denegado',
                    'message' => 'No tienes permisos para acceder a este reporte.',
                    'timer' => 5000
                ]);
        }

        return $next($request);
    }
}
