<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Inertia\Inertia;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    use AuthorizesRequests;
    /**
     * Carga el dashboard principal sin selección específica.
     */
    public function index()
    {
        if (!Auth::check()) {
            return redirect()->route('login');
        }

        return Inertia::render('Dashboard');
    }

    /**
     * Carga el dashboard con un reporte específico y/o cartera preseleccionada.
     */
    public function showReporte($id, Request $request)
    {
        if (!Auth::check()) {
            return redirect()->route('login');
        }

        // Buscar el reporte
        $reporte = \App\Models\Reporte::findOrFail($id);
        
        // Verificar si el usuario tiene acceso usando la Policy
        $this->authorize('view', $reporte);

        return Inertia::render('Dashboard', [
            'selectedReporteId' => (int) $id,
            'selectedCarteraId' => $request->query('cartera')
                ? (int) $request->query('cartera')
                : null,
        ]);
    }
}
