<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Role;

class AssignEnriquecimientoPermissions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'enriquecimiento:assign-permissions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Assign enriquecimiento permissions to admin role';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $admin = Role::where('name', 'admin')->first();

        if (!$admin) {
            $this->error('Admin role not found');
            return 1;
        }

        $permissions = [
            'enriquecimiento.ver',
            'enriquecimiento.crear',
            'enriquecimiento.eliminar',
            'enriquecimiento.importar'
        ];

        $admin->givePermissionTo($permissions);

        $this->info('Enriquecimiento permissions assigned to admin role successfully!');

        // Verificar permisos asignados
        $assignedPermissions = $admin->permissions->where('name', 'like', 'enriquecimiento%')->pluck('name')->toArray();
        $this->info('Assigned permissions: ' . implode(', ', $assignedPermissions));

        return 0;
    }
}
