# Genius Business - Sistema de Enriquecimiento de Datos

![Genius IA Logo](https://genius-ia.com/wp-content/uploads/2023/11/logo-genius-ia.png)

Sistema completo de gestión y enriquecimiento de datos telefónicos con integración de bot automatizado para procesamiento en tiempo real.

## Características Principales

- **Gestión de Enriquecimiento**: Importación y procesamiento de números telefónicos españoles
- **Sistema de Créditos**: Control de consumo por usuario con planes flexibles
- **Filtrado Avanzado**: Filtros por fecha, estado y tipo de importación
- **Bot Automatizado**: Procesamiento automático vía API externa
- **Interfaz Moderna**: Vue.js 3 + Inertia.js con componentes reactivos
- **Procesamiento en Tiempo Real**: Sistema de colas con Laravel Jobs
- **Exportación de Datos**: Generación de reportes en Excel

## Requisitos del Sistema

- **PHP**: >= 8.1
- **Composer**: >= 2.0
- **Node.js**: >= 18.0
- **NPM**: >= 9.0
- **MySQL**: >= 8.0
- **Redis**: >= 6.0 (opcional, para colas)

## Instalación y Configuración

### 1. Clonar el Repositorio

```bash
git clone https://github.com/IA-Genius/genius-business.git
cd genius-business
```

### 2. Instalar Dependencias

```bash
# Dependencias de PHP
composer install

# Dependencias de Node.js
npm install
```

### 3. Configuración del Entorno

```bash
# Copiar archivo de configuración
cp env-sample .env

# Generar clave de aplicación
php artisan key:generate
```

### 4. Configurar Base de Datos

Edita el archivo `.env` con tus credenciales de base de datos:

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=neobusiness
DB_USERNAME=root
DB_PASSWORD=tu_password
```

### 5. Configurar Colas

Para el procesamiento en segundo plano:

```env
QUEUE_CONNECTION=database
```

Si prefieres Redis (recomendado para producción):

```env
QUEUE_CONNECTION=redis
REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379
```

### 6. Ejecutar Migraciones

```bash
# Crear base de datos y tablas
php artisan migrate

# Ejecutar seeders (datos iniciales)
php artisan db:seed
```

### 7. Generar Storage Link

```bash
php artisan storage:link
```

### Bot API (Opcional)

El sistema incluye una API REST para bots externos que pueden procesar números automáticamente.

#### Configuración del Bot

```bash
# En tu archivo .env
BOT_ENABLED=true
BOT_MAX_CONCURRENT_JOBS=5
BOT_RETRY_ATTEMPTS=3
BOT_TIMEOUT_SECONDS=30
BOT_URL=http://localhost:8000
```

#### Endpoints Disponibles

**1. Procesar números desde bot externo**
```http
POST /api/enriquecimiento/procesar-bot
Content-Type: application/json

{
    "user_id": 1,
    "numeros": ["+57123456789", "+57987654321"],
    "metadata": {
        "origen": "bot_externo",
        "prioridad": "alta"
    }
}
```

**2. Actualizar estado de número procesado**
```http
POST /api/enriquecimiento/actualizar-estado
Content-Type: application/json

{
    "numero_id": 123,
    "estado": "procesado",
    "datos_enriquecidos": {
        "operador": "Claro",
        "tipo": "movil",
        "region": "Bogotá",
        "activo": true
    }
}
```

#### Ejemplo de Integración

Consulta el directorio `examples/` para ver:
- `bot_client_example.php` - Cliente PHP completo
- `test_bot_api.sh` - Script de pruebas
- `README.md` - Documentación detallada

#### Probar la API

```bash
# Ejecutar script de pruebas
cd examples
chmod +x test_bot_api.sh
./test_bot_api.sh
```

## Levantar el Proyecto

### Desarrollo

```bash
# Terminal 1: Servidor Laravel
php artisan serve

# Terminal 2: Compilación de assets
npm run dev

# Terminal 3: Procesador de colas
php artisan queue:work

# Terminal 4: Scheduler (opcional)
php artisan schedule:work
```

### Producción

```bash
# Compilar assets para producción
npm run build

# Configurar supervisor para colas
sudo apt install supervisor

# Crear archivo de configuración supervisor
sudo nano /etc/supervisor/conf.d/laravel-worker.conf
```

Contenido del archivo supervisor:

```ini
[program:laravel-worker]
process_name=%(program_name)s_%(process_num)02d
command=php /ruta/a/tu/proyecto/artisan queue:work --sleep=3 --tries=3 --max-time=3600
autostart=true
autorestart=true
stopasgroup=true
killasgroup=true
user=www-data
numprocs=1
redirect_stderr=true
stdout_logfile=/ruta/a/tu/proyecto/storage/logs/worker.log
stopwaitsecs=3600
```

```bash
# Recargar supervisor
sudo supervisorctl reread
sudo supervisorctl update
sudo supervisorctl start laravel-worker:*
```

## Uso del Sistema

### 1. Acceso al Sistema

- **URL**: `http://localhost:8000`
- **Usuario por defecto**: admin@genius-ia.com
- **Contraseña por defecto**: password123

### 2. Gestión de Enriquecimiento

1. Navega a **Enriquecimiento Operador**
2. Filtra por fecha específica usando el filtro flotante
3. Importa números mediante:
   - **Excel**: Subir archivo CSV/XLSX con columna "numero"
   - **Manual**: Escribir números línea por línea

### 3. Monitoreo en Tiempo Real

- El sistema actualiza automáticamente cada 3 segundos
- Estados disponibles: pendiente, procesando, procesado, rechazado, cancelado
- Estadísticas en tiempo real por fecha

### 4. Sistema de Créditos

- Cada usuario tiene créditos asignados según su plan
- El procesamiento consume créditos automáticamente
- Alertas cuando los créditos son insuficientes

## Estructura del Proyecto

```
genius-business/
├── app/
│   ├── Http/Controllers/
│   │   └── EnriquecimientoController.php    # Controlador principal
│   ├── Jobs/
│   │   └── ProcesarEnriquecimientoNumerosJob.php  # Job de procesamiento
│   └── Models/
│       ├── EnriquecimientoImportacion.php   # Modelo de importaciones
│       ├── EnriquecimientoNumero.php        # Modelo de números
│       └── UsuarioCredito.php               # Modelo de créditos
├── resources/
│   ├── js/Pages/
│   │   └── GestionarEnriquecimiento.vue     # Vista principal
│   └── js/Components/
│       ├── FiltroFlotante.vue               # Componente de filtros
│       └── SweetAlert.vue                   # Componente de alertas
└── routes/
    └── web.php                              # Rutas del sistema
```

## API del Bot

### Autenticación

Todas las requests deben incluir el header de autorización:

```
Authorization: Bearer {BOT_API_TOKEN}
```

### Procesar Números

```http
POST /api/enriquecimiento/procesar
Content-Type: application/json

{
    "user_id": 1,
    "numeros": [
        "612345678",
        "723456789",
        "634567890"
    ],
    "metadata": {
        "fuente": "bot_automatico",
        "prioridad": "alta"
    }
}
```

**Respuesta exitosa:**
```json
{
    "success": true,
    "importacion_id": 123,
    "numeros_procesados": 3,
    "creditos_utilizados": 3,
    "creditos_restantes": 47
}
```

### Actualizar Estado

```http
POST /api/enriquecimiento/actualizar-estado
Content-Type: application/json

{
    "numero_id": 456,
    "estado": "procesado",
    "datos_enriquecidos": {
        "operador": "Vodafone",
        "region": "Andalucía", 
        "tipo": "prepago",
        "activo": true
    }
}
```

**Respuesta exitosa:**
```json
{
    "success": true,
    "numero_actualizado": "612345678",
    "estado": "procesado"
}
```

## Troubleshooting

### Problemas Comunes

1. **Error de permisos en storage/**
   ```bash
   sudo chmod -R 775 storage/
   sudo chown -R www-data:www-data storage/
   ```

2. **Colas no procesan**
   ```bash
   # Verificar configuración
   php artisan queue:failed
   
   # Reiniciar worker
   php artisan queue:restart
   ```

3. **Assets no cargan**
   ```bash
   # Limpiar cache
   npm run build
   php artisan config:clear
   php artisan view:clear
   ```

4. **Base de datos no conecta**
   ```bash
   # Verificar configuración
   php artisan config:cache
   php artisan migrate:status
   ```

### Logs del Sistema

```bash
# Logs de Laravel
tail -f storage/logs/laravel.log

# Logs del worker
tail -f storage/logs/worker.log

# Logs de nginx (si aplica)
tail -f /var/log/nginx/error.log
```

## Contribución

1. Fork el proyecto
2. Crea una rama para tu feature (`git checkout -b feature/nueva-funcionalidad`)
3. Commit tus cambios (`git commit -am 'Agrega nueva funcionalidad'`)
4. Push a la rama (`git push origin feature/nueva-funcionalidad`)
5. Abre un Pull Request

## Soporte

Para soporte técnico:
- **Email**: soporte@genius-ia.com
- **Documentación**: [https://docs.genius-ia.com](https://docs.genius-ia.com)
- **Issues**: [GitHub Issues](https://github.com/IA-Genius/genius-business/issues)

## Licencia

Este proyecto está licenciado bajo la Licencia MIT - ver el archivo [LICENSE.md](LICENSE.md) para detalles.

---

**Genius IA** - Transformando datos en inteligencia empresarial.
